USE [BMS_DW]
GO

DROP TABLE [dbo].[FACT_WAITING_LIST]
GO 

/****** Object:  Table [dbo].[FACT_WAITING_LIST]    Script Date: 4/27/2016 2:26:46 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[FACT_WAITING_LIST](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[SOURCE_ID] [int] NOT NULL,
	[FACILITY_DIM_ORGANIZATION_ID] [int] NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [int] NULL,
	[DIM_WAITING_AREA_ID] [int] NULL,
	[PROBLEM] [nvarchar](max) NULL,
	[DIM_FEE_DISPOSITION_ID] [int] NULL,
	[DIM_CONTRACT_FEE_ID] [int] NULL,
	[DIM_AUTHORIZED_FEE_ID] [int] NULL,
	[DIM_SERVICE_RECEIVING_FEE_ID] [int] NULL,
	[DIM_REASON_USING_FEE_ID] [int] NULL,
	[FEE_COMMENTS] [nvarchar](150) NULL,
	[REMOVED_DATE] [datetime] NULL,
	[TYPE_OF_BED_WARD] [nvarchar](250) NULL,
	[DIM_REQUESTED_BED_ID] [int] NULL,
	[REQUESTED_BED_DATE] [datetime] NULL,
	[REQUESTED_DATE] [datetime] NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[REMOVED_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[REQUESTED_BED_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[REQUESTED_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[IS_IN_HOUSE] [bit] NULL,
	[COMMENTS] [nvarchar](150) NULL,
	[IS_BED_IN_ISOLATION] [bit] NOT NULL,
	[LAST_EDIT_BY] [nvarchar](100) NULL,
	[WAIT_TIME_ALERT_DATE] [datetime] NULL,
	[WAIT_TIME_ALERT_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[IS_COMMUNITY_LIVING_CENTER] [bit] NULL,
	[IS_EVACUATION_PATIENT] [bit] NULL,
	[DIM_EVACUATION_DISPOSITION_STATUS_ID] [int] NULL,
	[EVACUATION_EXPECTED_DATE] [datetime] NULL,
	[EVACUATION_EXPECTED_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[EVACUATION_ACTUAL_DATE] [datetime] NULL,
	[EVACUATION_ACTUAL_DATE_DIM_TIME_DAY_ID] [int] NULL,
	[EVACUATION_REASON_FOR_DELAY] [nvarchar](250) NULL,
	[EVACUATION_TRANSFER_EVACUATE_TO] [nvarchar](250) NULL,
	[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] [nvarchar](250) NULL,
	[EVACUATION_TRANSPORTATION_CARE_LEVEL] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] [nvarchar](250) NULL,
	[DIM_EVACUATION_TRANSPORTATION_TYPE_ID] [int] NULL,
	[DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID] [int] NULL,
	[EVACUATION_TRANSPORTATION_COMMENTS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_ADDRESS] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_CITY_STATE] [nvarchar](250) NULL,
	[EVACUATION_DESTINATION_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_ORIGINATOR_POC_TELEPHONE] [nvarchar](100) NULL,
	[EVACUATION_COMMENTS] [nvarchar](500) NULL,
	[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] [int] NULL,
	[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] [int] NULL,
	[DIM_PATIENT_ID] [int] NULL,
	[EVACUATION_ARRIVAL_TIME] [datetime] NULL,
	[EVACUATION_VEHICLE_ID] [nvarchar](250) NULL,
	[EVACUATION_VEHICLE_SEAT_POSITION] [nvarchar](250) NULL,
 CONSTRAINT [PK_FACT_WAITING_LIST] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 100) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_BED_ID] FOREIGN KEY([DIM_REQUESTED_BED_ID])
REFERENCES [dbo].[DIM_BED] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_BED_ID]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_CONTRACT] FOREIGN KEY([DIM_CONTRACT_FEE_ID])
REFERENCES [dbo].[DIM_CONTRACT] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_CONTRACT]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_CONTRACT_AUTHORIZED] FOREIGN KEY([DIM_AUTHORIZED_FEE_ID])
REFERENCES [dbo].[DIM_CONTRACT] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_CONTRACT_AUTHORIZED]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_DISPOSITION_STATUS] FOREIGN KEY([DIM_EVACUATION_DISPOSITION_STATUS_ID])
REFERENCES [dbo].[DIM_EVAC_DISPOSITION_STATUS] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_DISPOSITION_STATUS]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID] FOREIGN KEY([DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID])
REFERENCES [dbo].[DIM_EVAC_TRANSPORTATION_PROVIDER] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_TRANSPORTATION_TYPE] FOREIGN KEY([DIM_EVACUATION_TRANSPORTATION_TYPE_ID])
REFERENCES [dbo].[DIM_EVAC_TRANSPORTATION_TYPE] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_EVACUATION_TRANSPORTATION_TYPE]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_FEE_DISPOSITION] FOREIGN KEY([DIM_FEE_DISPOSITION_ID])
REFERENCES [dbo].[DIM_FEE_DISPOSITION] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_FEE_DISPOSITION]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_PATIENT] FOREIGN KEY([DIM_PATIENT_ID])
REFERENCES [dbo].[DIM_PATIENT] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_PATIENT]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_REASON_USING_FEE] FOREIGN KEY([DIM_REASON_USING_FEE_ID])
REFERENCES [dbo].[DIM_FEE_REASON] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_REASON_USING_FEE]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_SERVICE_RECEIVING_FEE] FOREIGN KEY([DIM_SERVICE_RECEIVING_FEE_ID])
REFERENCES [dbo].[DIM_SERVICE_RECEIVING_FEE] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_SERVICE_RECEIVING_FEE]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_DIM_WAITING_AREA] FOREIGN KEY([DIM_WAITING_AREA_ID])
REFERENCES [dbo].[DIM_WAITING_AREA] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_DIM_WAITING_AREA]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_FACILITY_DIM_ORGANIZATION] FOREIGN KEY([FACILITY_DIM_ORGANIZATION_ID])
REFERENCES [dbo].[DIM_ORGANIZATION] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_FACILITY_DIM_ORGANIZATION]
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST]  WITH NOCHECK ADD  CONSTRAINT [FK_FACT_WAITING_LIST_VISTA_SITE_DIM_ORGANIZATION] FOREIGN KEY([VISTA_SITE_DIM_ORGANIZATION_ID])
REFERENCES [dbo].[DIM_ORGANIZATION] ([ID])
GO

ALTER TABLE [dbo].[FACT_WAITING_LIST] CHECK CONSTRAINT [FK_FACT_WAITING_LIST_VISTA_SITE_DIM_ORGANIZATION]
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The act id from the BMS database, source table WAITING_LIST, ACT_ID column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'SOURCE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The Id of the facility that was requested for the admission.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'FACILITY_DIM_ORGANIZATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista site id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'VISTA_SITE_DIM_ORGANIZATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Indicates the area where the patient waits to be admitted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_WAITING_AREA_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the presented problem or diagnostic of  the patient.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'PROBLEM'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee utilization - concept.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_FEE_DISPOSITION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the fee contract (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_CONTRACT_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the authorized fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_AUTHORIZED_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the service receiving fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_SERVICE_RECEIVING_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the reason using fee (concept).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_REASON_USING_FEE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Fee comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'FEE_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Removed from waiting list date time.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REMOVED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of bed or ward that the patient needs.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'TYPE_OF_BED_WARD'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the bed requested.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_REQUESTED_BED_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date when the bed was requested.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REQUESTED_BED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the patient was added in the waiting list.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REQUESTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the row has been inserted or modified.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'_SSIS_TIMESTAMP'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Removed date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REMOVED_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Requested bed date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REQUESTED_BED_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Requested date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REQUESTED_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient already admitted to current facility.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'IS_IN_HOUSE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether bed is in isolation or not.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'IS_BED_IN_ISOLATION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Wait time alert.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'WAIT_TIME_ALERT_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Wait time alert date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'WAIT_TIME_ALERT_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Community Living Center (CLC) patients and future scheduled patients' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'IS_COMMUNITY_LIVING_CENTER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Whether patient is in evacuation or not.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'IS_EVACUATION_PATIENT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation disposition status id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_EVACUATION_DISPOSITION_STATUS_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation expected pick-up date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_EXPECTED_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Evacuation expected date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_EXPECTED_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation actual pick-up date.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ACTUAL_DATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Id of the time day from the dimension time day table (Evacuation actual date from the waiting list). Not mapped to BMS.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ACTUAL_DATE_DIM_TIME_DAY_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation reason fro delay.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_REASON_FOR_DELAY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation transfer/Evacuate to.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSFER_EVACUATE_TO'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Equip/Supply Requirements.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_EQUIP_SUPPLY_REQUIREMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Care Level.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_CARE_LEVEL'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Medical Attendant.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Non-Medical Attendant.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Type Id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_EVACUATION_TRANSPORTATION_TYPE_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Provider Id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_EVACUATION_TRANSPORTATION_PROVIDER_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Transportation Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_TRANSPORTATION_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination Address.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_ADDRESS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination City/State.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_CITY_STATE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Destination POC Phone.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_DESTINATION_POC_TELEPHONE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Originator POC Phone.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ORIGINATOR_POC_TELEPHONE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Comments.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_COMMENTS'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Medical Attendant Number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Evacuation Enroute Non-Medical Attendant Number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The patient id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST', @level2type=N'COLUMN',@level2name=N'DIM_PATIENT_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient waiting list table.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_WAITING_LIST'
GO


